<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\LeaderController;
use App\Http\Controllers\Api\TestimonialController;
use App\Http\Controllers\Api\PrayerRequestController;
use App\Http\Controllers\Api\ChurchPointController;
use App\Http\Controllers\Api\MeetingController;
use App\Http\Controllers\Api\UserMeetingController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
//--------------------------------
//User Routes
//--------------------------------

Route::get('/test', function () {
    return response()->json(['message' => 'Welcome to the API']);
});

Route::post('/login', [UserController::class, 'UserLogin']); 
Route::post('/forgot-password',[UserController::class ,'Forgotpassword']);
Route::post('/verify-otp',[UserController::class ,'VerifyOtp']);
Route::post('/reset-password',[UserController::class,'Resetpassword']);


Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/authentication', [UserController::class, 'Authentication']);
});

Route::middleware(['auth:sanctum', 'role:user'])->group(function () {
    
    //profile
    Route::get('user/show_profile', [UserController::class, 'ViewProfile']);
    Route::post('user/update_profile',[UserController::class,'UpdateProfile']);
    Route::post('user/update_profile_pic', [UserController::class, 'UpdateProfilePic']);
    Route::post('logout',[UserController::class,'Logout']);

    //Testimonial
    Route::post('user/add_testimonial',[TestimonialController::class,'AddTestimonial']);
    Route::get('user/show_testimonial',[TestimonialController::class,'ShowTestimonial']);

    //PrayerRequest
    Route::get('user/prayer_request',[PrayerRequestController::class,'PrayerRequest']);
    Route::post('user/add_prayer_request',[PrayerRequestController::class,'AddPrayerRequest']);
    Route::post('user/prayerrequestIprayed/{id}',[PrayerRequestController::class,'IPrayed']);

    //Get Meetings
    Route::get('user/get_meetings',[UserMeetingController::class,'GetMeeting']);
    Route::get('user/join_meeting/{id}',[UserMeetingController::class,'JoinMeeting']);
    
    //Progress
    Route::get('user/progress',[UserController::class,'Progress']);

    //Notification
    Route::get('user/notification',[UserController::class,'Notification']);

});

//--------------------------------
//Leader Routes
//--------------------------------


Route::middleware(['auth:sanctum', 'role:leader'])->group(function () {

    //Profile
    Route::get('leader/show_profile', [LeaderController::class, 'ViewProfile']);
    Route::post('leader/update_profile',[LeaderController::class,'UpdateProfile']);
    Route::post('leader/update_profile_pic', [LeaderController::class, 'UpdateProfilePic']);

    //Testimonial
    Route::post('leader/add_testimonial',[TestimonialController::class,'AddTestimonial']);
    Route::get('leader/show_testimonial',[TestimonialController::class,'ShowTestimonial']);

    //Prayer request
    Route::get('leader/prayer_request',[PrayerRequestController::class,'PrayerRequest']);
    Route::post('leader/add_prayer_request',[PrayerRequestController::class,'AddPrayerRequest']);
    Route::post('leader/prayerrequestIprayed/{id}',[PrayerRequestController::class,'IPrayed']);
    
    //Users
    Route::post('leader/add_user',[UserController::class,'AddUser']);
    Route::get('leader/show_user',[UserController::class,'ShowUser']);
    Route::get('leader/edit_user/{id}',[UserController::class,'EditUser']);
    Route::post('leader/update_user/{id}',[UserController::class,'UpdateUser']);
    Route::delete('leader/delete_user/{id}',[UserController::class,'DeleteUser']);
    Route::get('leader/show_all_leader',[UserController::class,'ViewAllLeader']);

    //Church Prayer Points
    Route::post('leader/add_churchpoint',[ChurchPointController::class,'AddChurchPoint']);
    Route::get('leader/shows_churchpoint',[ChurchPointController::class,'ShowsChurchPoint']);
    Route::get('leader/edit_churchpoint/{id}',[ChurchPointController::class,'EditChurchpoint']);
    Route::post('leader/update_churchpoint/{id}',[ChurchPointController::class,'UpdateChurchpoint']);
    Route::delete('leader/delete_churchpoint/{id}',[ChurchPointController::class,'DeleteChurchpoint']);
    Route::get('leader/filtered_prayer_point',[ChurchPointController::class,'FilteredPrayerPoint']);
    
    //Meetings
    Route::post('leader/create_meeting',[MeetingController::class,'CreateMeeting']);
    Route::get('leader/show_meeting',[MeetingController::class,'ShowMeeting']);
    Route::post('leader/cancle_meeting/{id}',[MeetingController::class,'CancleMeeting']);
    Route::get('leader/show_all_categories',[MeetingController::class,'ShowAllCategory']);
    Route::get('leader/prayer_point_filter',[MeetingController::class,'ShowPrayerFilterPoints']);
    Route::get('leader/start_meeting/{id}',[MeetingController::class,'StartMeeting']);

    Route::post('leader/update_church_prayer_point/{id}',[MeetingController::class,'UpdateChurchPoint']);
    Route::post('leader/update_theme_prayer_point/{id}',[MeetingController::class,'UpdateThemePoint']);
    Route::post('leader/prayer_point_prayed/{id}',[MeetingController::class,'PrayerPointPrayed']);
    Route::post('leader/prayed',[MeetingController::class,'Prayed']);
    Route::get('leader/join_meeting_participants/{id}',[MeetingController::class ,'JoinMeetingParticipants']);
    Route::get('leader/prayer_logs/{id}',[MeetingController::class ,'PrayerLog']);
    Route::post('leader/meeting_status/{id}',[MeetingController::class ,'MeetingStatus']);
    
    Route::post('leader/update_key_prayer_point/{id}',[MeetingController::class,'UpdateKeyPrayerPoint']);
    Route::post('leader/update_prayer_request_point/{id}',[MeetingController::class,'UpdatePrayerRequestPoint']);


    //ChurchPoint
    Route::get('leader/shows_themeprayerpoint/{id}',[ChurchPointController::class,'ShowsThemePrayerPoint']);
    Route::get('leader/show_theme_prayer_sub_category',[ChurchPointController::class,'ShowThemePrayerSubCategory']);
    
    //progress
    Route::get('leader/progress',[LeaderController::class,'Progress']);

    //Notification
    Route::get('leader/notification',[LeaderController::class,'Notification']);
    
    //Logout
    Route::post('logout',[UserController::class,'Logout']);
    
});
