<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OTP Verification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 40px auto;
            background: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .header {
            font-size: 26px;
            font-weight: bold;
            color: #333;
            padding-bottom: 10px;
            border-bottom: 2px solid #eee;
        }
        .content {
            font-size: 16px;
            color: #555;
            line-height: 1.8;
            padding: 20px 10px;
        }
        .otp-box {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 10px;
            display: inline-block;
            width: 80%;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
            margin-top: 20px;
        }
        .otp-code {
            font-size: 32px;
            font-weight: bold;
            color: #007bff;
            letter-spacing: 3px;
            display: block;
            margin: 10px 0;
        }
        .footer {
            font-size: 14px;
            color: #777;
            padding-top: 15px;
            border-top: 2px solid #eee;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        OTP Verification
    </div>

    <div class="content">
        <p>Hello Dear,</p>
        <p>Your One-Time Password (OTP) for verification is:</p>
        
        <div class="otp-box">
            <span class="otp-code">{{ $otp }}</span>
        </div>

        <p>Please enter this code to complete your verification process. If you did not request this OTP, please ignore this email.</p>
    </div>

    <div class="footer">
        <p>Thank you,<br><strong>The Team</strong></p>
    </div>
</div>

</body>
</html>
