<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Testimonial;
use Carbon\Carbon;

class TestimonialController extends Controller
{
    public function AddTestimonial(Request $request)
    {

        $user = Auth::user();
        $user_id = $user->id;
        $church_id = $user->church_id;
 
        if (!$user) {
            return response()->json([
                'status' => 404,
                'message' => 'User not found',
            ], 404);
        }
        // validatting fields
        $validator = Validator::make($request->all(), [
            'description' => 'required|string|max:250', 
            'date' => [
                'required',
                'date_format:d-m-Y', 
            ],
        ]);
    
       if ($validator->fails()) {
            $errors = $validator->errors()->all(); 
        
            return response()->json([
                'status' => 422,
                'message' => $errors, 
            ], 422);
        }
        
        $formattedDate = Carbon::parse($request->date)->format('Y-m-d');

        $Testimonial = new Testimonial();
        $Testimonial->user_id = $user_id; 
        $Testimonial->church_id = $church_id;
        $Testimonial->date = $formattedDate;
        $Testimonial->description = $request->description;
        $Testimonial->save();

        return response()->json([
            'status' => 200,
            'message' => 'Testimonial Created successfully',
            'Testimonial' => $Testimonial,
        ], 200);
    }

   public function ShowTestimonial()
   {
    try {
        $user = Auth::user();

        if (!$user) {
            return response()->json([
                'status' => 404,
                'message' => 'User not found',
            ], 404);
        }

        // Fetch testimonials and transform data
        $testimonials = Testimonial::where('church_id', $user->church_id)
            ->with('user') // Eager load user data
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get()
            ->map(function ($testimonial) {
                return [
                    'id' => $testimonial->id,
                    'date' => $testimonial->date,
                    'description' => $testimonial->description,
                    'name' => $testimonial->user ? $testimonial->user->first_name . ' ' . $testimonial->user->last_name : '', 
                    'role' => $testimonial->user ? $testimonial->user->user_role : '', 
                    'profile_photo' => $testimonial->user && $testimonial->user->profile_photo
                        ? asset($testimonial->user->profile_photo)  
                        : asset('user_profile/profile.png'), 
                ];
            });

            return response()->json([
                'status' => 200,
                'message' => 'Testimonials retrieved successfully',
                'testimonials' => $testimonials,
            ], 200);
        } catch (\Exception $e) {
            \Log::error('Error updating profile picture: ' . $e->getMessage());
            
            return response()->json([
                'status' => 500,
                  'message' => 'Internal Server Error',
            ], 500);
        }
    }

}
