
<?php $__env->startSection('content'); ?>
<div class="app-title">
    <div>
        <h1>
            <i class="fa-regular fa-plus mx-1"></i> Add Prayer Point
        </h1>
    </div>
</div>
<!-- div for top tittle end here -->
<!-- page content start from here -->
<section class="acc-form">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
                <div class="tile">
                    <div class="tile-body">
                        <!-- form start from here -->
                        <form class="emp-master-form" action="<?php echo e(route('admin.store_prayer_point')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="options">Prayer Category:</label>
                                        <select id="options" name="prayer_category_id" class="form-control">
                                            <option value="" disabled <?php echo e(old('prayer_category_id') ? '' : 'selected'); ?>>Select Prayer Category</option>
                                            <?php $__currentLoopData = $prayer_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prayer_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($prayer_category->id); ?>" <?php echo e(old('prayer_category_id') == $prayer_category->id ? 'selected' : ''); ?>>
                                                <?php echo e($prayer_category->prayer_category_name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['prayer_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Prayer Sub-Category Dropdown -->
                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_sub_category_id">Prayer Sub-Category:</label>
                                        <select id="prayer_sub_category_id" name="prayer_sub_category_id" class="form-control">
                                            <option value="" disabled selected>Select Prayer Sub-Category</option>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['prayer_sub_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_point">Prayer Point:</label>
                                        <textarea class="form-control" name="prayer_point" id="prayer_point" placeholder="Enter Prayer Point"><?php echo e(old('prayer_point')); ?></textarea>
                                    </div>
                                    <?php $__errorArgs = ['prayer_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>


                                <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
                                    <div class="form-group text-center">
                                        <button class="btn submit-btn w-100" type="submit">
                                            <i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Add Prayer Point </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- fom end here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?php echo e(session('success')); ?>",
        confirmButtonText: 'OK'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "<?php echo e(route('admin.prayer_points')); ?>";
        }
    });
</script>
<?php endif; ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

<!-- Your custom script -->
<script>
    $(document).ready(function () {
        $('#options').on('change', function () {
            var categoryId = $(this).val();

            if (categoryId) {
                $.ajax({
                    type: 'GET',
                    url: '<?php echo e(route("admin.get_prayer_sub_categories")); ?>',
                    data: { categoryId: categoryId },
                    success: function (response) {
                        var subCategorySelect = $('#prayer_sub_category_id');
                        subCategorySelect.empty();
                        subCategorySelect.append('<option value="" disabled selected>Select Prayer Sub-Category</option>');

                        if (response.sub_categories.length > 0) {
                            $.each(response.sub_categories, function (index, subCategory) {
                                subCategorySelect.append(`<option value="${subCategory.id}">${subCategory.prayer_sub_cat_name}</option>`);
                            });
                        } else {
                            subCategorySelect.append('<option value="" disabled>No Sub-Categories Available</option>');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching sub-categories:', error);
                    }
                });
            } else {
                $('#prayer_sub_category_id').empty().append('<option value="" disabled selected>Select Prayer Sub-Category</option>');
            }
        });
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pragyadbtechserv/public_html/church-admin/resources/views/admin/add_prayer_points.blade.php ENDPATH**/ ?>