@extends('admin.layouts.app')
@section('content') 

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Notification Management
        </h1>
      </div>
    </div>
    <section class="leavereq-info">
      <div class="container">
       		<div class="row justify-content-center">
			<div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
				<div class="tile">
					<div class="tile-body">


						<!-- form start from here -->
					<form class="emp-master-form" action="{{ route('admin.add_notification')}}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <!-- Title Field -->
                            <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                <div class="form-group">
                                    <label class="form-head mb-1" for="title">Title:</label>
                                    <input type="text" class="form-control" name="title" id="title" placeholder="Enter Title" value="{{ old('title') }}">
                                </div>
                                @error('title')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                    
                            <!-- Message Field -->
                            <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                <div class="form-group">
                                    <label class="form-head mb-1" for="message">Message:</label>
                                    <textarea class="form-control" name="message" id="message" rows="4" placeholder="Enter Message">{{ old('message') }}</textarea>
                                </div>
                                @error('message')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                    
                      

						<div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
							<div class="form-group text-center">
								<button class="btn submit-btn w-100" type="submit">
									<i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Add Church </button>
							</div>
						</div>
					</div>
					</form>
					<!-- fom end here -->
				</div>
			</div>
		</div>
	</div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">
                    <thead>
                      <tr>
                      <th>S.No.</th>
                        <th>Title</th>
                        <th>Message</th>
                      </tr>
                    </thead>
                    <tbody>
                      @if(count($notifications) > 0 )
                          @foreach($notifications as $notification)
                          <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $notification->title ?? ''}}</td>
                            <td>{{ $notification->message ?? ''}}</td>
                          </tr>
                          @endforeach
                        @else
                        <tr>
                            <td colspan="6" class="text-center">No Notification added yet,Lets add notification.</td>
                        </tr>
                        @endif

                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    @if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "{{ session('success') }}",
            confirmButtonText: 'OK'
        }).then((result) => {
           
        });
    </script>
  @endif

  @if (session('error'))
      <script>
          Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: "{{ session('error') }}",
              confirmButtonText: 'OK'
          });
      </script>
  @endif
  
@endsection