@extends('admin.layouts.app')
@section('content') 

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Leader Management
        </h1>
      </div>
    </div>
    <section class="leavereq-info">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="buttons-container">
              <div id="buttons-container"></div>
              <a class="add-emp btn" href="{{ route('admin.add_leader')}}"><i class="fa-regular fa-plus"></i> Add New Leader</a>
            </div>
          </div>
        </div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">
                    <thead>
                      <tr>
                      <th>S.No.</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email Id</th>
                        <th>Phone no.</th>
                        <th>User Role </th>
                        <th>User Status </th>
                        <th>Church Assign</th>
					              <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      @if(count($leaders) > 0)
                          @foreach($leaders as $leader)
                          <tr>
                            <td>{{ $loop->iteration}}</td>
                            <td>{{ $leader->first_name ?? ''}}</td>
                            <td>{{ $leader->last_name ?? ''}}</td>
                            <td>{{ $leader->email ?? ''}}</td>
                            <td>{{ $leader->phone_no ?? ''}}</td>
                            <td>{{ $leader->user_role ?? ''}}</td>
                            <td>{{ $leader->user_status ?? ''}}</td>
                            <td>{{ $leader->church->church_name ?? ''}}</td>

                            <td class="flex-td">
                              <a href="{{ route('admin.edit_leader',$leader->id)}}" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                              <a href="{{ route('admin.delete_leader',$leader->id) }}" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                            </td>
                          </tr>
                          @endforeach
                        @else
                          <tr>
                              <td colspan="7" class="text-center">No Church Leader found  yet,Lets Add Church Leaders.</td>
                          </tr>
                        @endif
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "{{ session('success') }}",
        confirmButtonText: 'OK'
    }).then((result) => {
       
    });
</script>
@endif

@if (session('error'))
  <script>
      Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: "{{ session('error') }}",
          confirmButtonText: 'OK'
      });
  </script>
@endif

@endsection