@extends('admin.layouts.app')
@section('content')
<div class="app-title">
    <div>
        <h1>
            <i class="fa-regular fa-plus mx-1"></i> Edit Prayer Sub Category
        </h1>
    </div>
</div>
<!-- div for top tittle end here -->
<!-- page content start from here -->
<section class="acc-form">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
                <div class="tile">
                    <div class="tile-body">
                        <!-- form start from here -->
                        <form class="emp-master-form" action="{{ route('admin.update_prayer_sub_category',$prayer_sub_category->id)}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{ $prayer_sub_category->id }}">

                            <div class="row">

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="options">Prayer Category:</label>
                                        <select id="options" name="prayer_category_id" class="form-control">
                                            <option value="" disabled>Select Prayer Category</option>
                                            @foreach ($prayer_categories as $prayer_category)
                                            <option value="{{ $prayer_category->id }}"
                                                {{ $prayer_sub_category->prayer_category_id == $prayer_category->id ? 'selected' : '' }}>
                                                {{ $prayer_category->prayer_category_name }}
                                            </option>

                                            @endforeach
                                        </select>

                                    </div>
                                    @error('prayer_category_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Prayer Sub-Category Dropdown -->
                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_sub_cat_name">Prayer Sub-Catergory Name:</label>
                                        <input class="form-control" name="prayer_sub_cat_name" id="prayer_sub_cat_name" placeholder="Enter Prayer Sub-Category Name" value="{{ $prayer_sub_category->prayer_sub_cat_name ?? ''}}"></input>
                                    </div>
                                    @error('prayer_sub_cat_name')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_sub_cat_description">Prayer Sub-Catergory Description:</label>
                                        <textarea class="form-control" name="prayer_sub_cat_description" id="prayer_sub_cat_description" placeholder="Enter Sub-Category Description">{{ old('prayer_sub_cat_description', $prayer_sub_category->prayer_sub_cat_description ?? '') }}</textarea>
                                    </div>
                                    @error('prayer_sub_cat_description')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
                                    <div class="form-group text-center">
                                        <button class="btn submit-btn w-100" type="submit">
                                            <i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Update Prayer Sub-Category </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- fom end here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "{{ session('success') }}",
        confirmButtonText: 'OK'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ route('admin.prayer_sub_category') }}";
        }
    });
</script>
@endif
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

@endsection