@extends('admin.layouts.app')
@section('content') 

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Church Management
        </h1>
      </div>
    </div>
    <section class="leavereq-info">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="buttons-container">
              <div id="buttons-container"></div>
              <a class="add-emp btn" href="{{ route('admin.add_church')}}"><i class="fa-regular fa-plus"></i> Add New Church</a>
            </div>
          </div>
        </div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">
                    <thead>
                      <tr>
                      <th>S.No.</th>
                        <th>Church Name</th>
                        <th>Denomination</th>
                        <th>Church Logo</th>
                        <th>Status</th>
					              <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      @if(count($churches) > 0 )
                          @foreach($churches as $church)
                          <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $church->church_name ?? ''}}</td>
                            <td>{{ $church->denomination ?? ''}}</td>
                            <td>
                                <img src="{{ asset( $church->church_logo) }}" alt="Church Logo" width="50" height="50">
                            </td>
                            <td>
                                @if($church->status == 'Active')
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                            </td>
                            <td class="flex-td">
                              <a href="{{ route('admin.edit_church',$church->id )}}" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                              <a href="{{ route('admin.delete_church',$church->id )}}" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                            </td>
                          </tr>
                          @endforeach
                        @else
                        <tr>
                            <td colspan="6" class="text-center">No Church Added yet,Lets Add Church.</td>
                        </tr>
                        @endif

                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    @if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "{{ session('success') }}",
            confirmButtonText: 'OK'
        }).then((result) => {
           
        });
    </script>
  @endif

  @if (session('error'))
      <script>
          Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: "{{ session('error') }}",
              confirmButtonText: 'OK'
          });
      </script>
  @endif
  
@endsection