@extends('admin.layouts.app')
@section('content')
<div class="app-title">
    <div>
        <h1>
            <i class="fa-regular fa-plus mx-1"></i> Add Prayer Point
        </h1>
    </div>
</div>
<!-- div for top tittle end here -->
<!-- page content start from here -->
<section class="acc-form">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
                <div class="tile">
                    <div class="tile-body">
                        <!-- form start from here -->
                        <form class="emp-master-form" action="{{ route('admin.store_prayer_point')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="options">Prayer Category:</label>
                                        <select id="options" name="prayer_category_id" class="form-control">
                                            <option value="" disabled {{ old('prayer_category_id') ? '' : 'selected' }}>Select Prayer Category</option>
                                            @foreach ($prayer_categories as $prayer_category)
                                            <option value="{{ $prayer_category->id }}" {{ old('prayer_category_id') == $prayer_category->id ? 'selected' : '' }}>
                                                {{ $prayer_category->prayer_category_name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('prayer_category_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Prayer Sub-Category Dropdown -->
                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_sub_category_id">Prayer Sub-Category:</label>
                                        <select id="prayer_sub_category_id" name="prayer_sub_category_id" class="form-control">
                                            <option value="" disabled selected>Select Prayer Sub-Category</option>
                                        </select>
                                    </div>
                                    @error('prayer_sub_category_id')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
                                    <div class="form-group">
                                        <label class="form-head mb-1" for="prayer_point">Prayer Point:</label>
                                        <textarea class="form-control" name="prayer_point" id="prayer_point" placeholder="Enter Prayer Point">{{ old('prayer_point') }}</textarea>
                                    </div>
                                    @error('prayer_point')
                                    <div class="text-danger mt-1">{{ $message }}</div>
                                    @enderror
                                </div>


                                <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
                                    <div class="form-group text-center">
                                        <button class="btn submit-btn w-100" type="submit">
                                            <i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Add Prayer Point </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <!-- fom end here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "{{ session('success') }}",
        confirmButtonText: 'OK'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ route('admin.prayer_points') }}";
        }
    });
</script>
@endif
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

<!-- Your custom script -->
<script>
    $(document).ready(function () {
        $('#options').on('change', function () {
            var categoryId = $(this).val();

            if (categoryId) {
                $.ajax({
                    type: 'GET',
                    url: '{{ route("admin.get_prayer_sub_categories") }}',
                    data: { categoryId: categoryId },
                    success: function (response) {
                        var subCategorySelect = $('#prayer_sub_category_id');
                        subCategorySelect.empty();
                        subCategorySelect.append('<option value="" disabled selected>Select Prayer Sub-Category</option>');

                        if (response.sub_categories.length > 0) {
                            $.each(response.sub_categories, function (index, subCategory) {
                                subCategorySelect.append(`<option value="${subCategory.id}">${subCategory.prayer_sub_cat_name}</option>`);
                            });
                        } else {
                            subCategorySelect.append('<option value="" disabled>No Sub-Categories Available</option>');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error('Error fetching sub-categories:', error);
                    }
                });
            } else {
                $('#prayer_sub_category_id').empty().append('<option value="" disabled selected>Select Prayer Sub-Category</option>');
            }
        });
    });
</script>


@endsection