<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use App\Models\PrayerCategory;
use App\Models\PrayerLog;
use App\Models\PrayerSubCategory;
use App\Models\PrayerPoint;
use Exception;

class PrayerPointController extends Controller
{
    public function PrayerPoints()
    {
        $prayer_points = PrayerPoint::with(['category', 'subCategory'])
        ->get();
        return view('admin.prayer_point',compact('prayer_points'));
    }
    public function AddPrayerPoints(Request $request)
    {

        $prayer_categories = PrayerCategory::get();
        $prayer_sub_categories = PrayerSubCategory::all();
        return view('admin.add_prayer_points', compact('prayer_categories', 'prayer_sub_categories'));
    }

    public function getPrayerSubCategories(Request $request)
    {
        $categoryId = $request->categoryId;
        $prayer_sub_categories = PrayerSubCategory::where('prayer_category_id', $categoryId)->get();

        return response()->json([
            'sub_categories' => $prayer_sub_categories
        ]);
    }

    public function StorePrayerPoint(Request $request){

        $request->validate([
            'prayer_category_id' => 'required|exists:prayer_categories,id',
            'prayer_sub_category_id' => 'required|exists:prayer_sub_categories,id',
            'prayer_point' => 'required|string|max:255',
        ]);
         

        $prayerpoint = new PrayerPoint();
        $prayerpoint->prayer_category_id = $request->input('prayer_category_id');
        $prayerpoint->prayer_sub_category_id = $request->input('prayer_sub_category_id');
        $prayerpoint->prayer_point = $request->input('prayer_point');    
        $prayerpoint->save();

        return redirect()->back()->with('success','Prayer Point Updated Successfully!');
    }

    public function PrayerUpdateStatus(Request $request){

        $prayerPoint = PrayerPoint::find($request->id);
        if ($prayerPoint) {
            $prayerPoint->status = $request->status;
            $prayerPoint->save();
            
            return response()->json(['success' => true, 'message' => 'Status updated successfully'], 200);
        }
        return response()->json(['success' => false, 'message' => 'Prayer point not found'], 400);
    }

    public function EditPrayerPoint($id){

        $prayer_point = PrayerPoint::findOrfail($id);
        $prayer_categories = PrayerCategory::get();
        $prayer_sub_categories = PrayerSubCategory::where('prayer_category_id', $prayer_point->prayer_category_id)->get();
        return view('admin.edit_prayer_point',compact('prayer_point','prayer_categories','prayer_sub_categories'));
    }

    public function UpdatePrayerPoint(Request $request, $id)
    {
        $request->validate([
            'prayer_category_id' => 'required|exists:prayer_categories,id',
            'prayer_sub_category_id' => 'required|exists:prayer_sub_categories,id',
            'prayer_point' => 'required|string|max:255',
        ]);
    
        $prayerpoint = PrayerPoint::findOrFail($id);
    
        $prayerpoint->prayer_category_id = $request->input('prayer_category_id');
        $prayerpoint->prayer_sub_category_id = $request->input('prayer_sub_category_id');
        $prayerpoint->prayer_point = $request->input('prayer_point');
        $prayerpoint->save();
        
        return redirect()->back()->with('success', 'Prayer Point Updated Successfully!');
    }
    

    public function DeletePrayerPoint($id)
    {
        try {
            $prayer_point = PrayerPoint::find($id);
            if (!$prayer_point) {
                return back()->with('error', 'Prayer Point not found.');
            }
            $prayer_point->delete();
            return back()->with('success', 'Prayer Point Deleted Successfully');
        } catch (Exception $e) {
            
            return back()->with('error', 'An error occurred while deleting the prayer point.');
        }
    }
}
