<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Church;
use Exception;

class ChurchManagementController extends Controller
{
    public function Church(){

        $churches = Church::OrderBy('created_at','desc')->get();

        return view('admin.church',compact('churches'));
    }

    public function AddChurch(){
        
        return view('admin.add_church');
    }

    public function StoreChurch(Request $request){

        $request->validate([
            'church_name' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'denomination' => 'required',
            'church_logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048', 
        ]);    

        // church_logo
        if ($request->hasFile('church_logo')) {
            $file = $request->file('church_logo');
            $filename = 'church_logo_' . uniqid() . '.' . $file->getClientOriginalExtension();
    
            $path = public_path('images/church/' . $filename);
            $file->move(public_path('images/church'), $filename);
            $church_logo = 'images/church/' . $filename;
        }

        $church = new Church();
        $church->church_name = $request->input('church_name');
        $church->city = $request->input('city');
        $church->state = $request->input('state');
        $church->denomination = $request->input('denomination');
        $church->church_logo = $church_logo;
        $church->save();
        return redirect()->back()->with('success','Church Added Successfully');
    }

    public function EditChurch($id){

        $church = Church::find($id);
        return view('admin.edit_church',compact('church'));
    }
    
    public function UpdateChurch(Request $request,$id){

        $church = Church::find($id);
        $request->validate([
            'church_name' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'denomination' => 'required',
            'church_logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048', 
        ]);    


        if ($request->hasFile('church_logo')) {
            if ($church->church_logo && file_exists(public_path($church->church_logo))) {
                unlink(public_path($church->church_logo));
            }

            $file = $request->file('church_logo');
            $filename = 'church_logo_' . uniqid() . '.' . $file->getClientOriginalExtension();
            $path = public_path('images/church/' . $filename);
            $file->move(public_path('images/church'), $filename);
            $church->church_logo = 'images/church/' . $filename;
        }

        $church->church_name = $request->input('church_name');
        $church->denomination = $request->input('denomination');
        $church->city = $request->input('city');    
        $church->state = $request->input('state');
        $church->save();

        return redirect()->back()->with('success','Church Updated Successfully!');
    }

    public function DeleteChurch($id)
    {
        try {
            $church = Church::find($id);
            if (!$church) {
                return back()->with('error', 'Church not found.');
            }
            $church->delete();
            return back()->with('success', 'Church Deleted Successfully');
        } catch (Exception $e) {
            
            return back()->with('error', 'An error occurred while deleting the church.');
        }
    }
}
