<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prayer_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('church_id')->nullable();  
            $table->unsignedBigInteger('user_id')->nullable(); 
            $table->unsignedBigInteger('prayer_category_id')->nullable();
            $table->date('date')->nullable(); 
            $table->text('description')->nullable(); 
            $table->foreign('prayer_category_id')->references('id')->on('prayer_categories')->onDelete('cascade');
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prayer_requests');
    }
};
