<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prayer_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('church_id')->nullable();  
            $table->unsignedBigInteger('user_id')->nullable();  
            $table->unsignedBigInteger('church_prayer_points_id')->nullable();  
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade'); 
            $table->foreign('church_prayer_points_id')->references('id')->on('church_prayer_points')->onDelete('cascade');  
            $table->enum('status', ['Prayed', 'UnPrayed'])->default('UnPrayed')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prayer_logs');
    }
};
