<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('meetings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('church_id')->nullable();  
            $table->unsignedBigInteger('user_id')->nullable();  
            $table->unsignedBigInteger('church_prayer_points_id')->nullable();  
            $table->unsignedBigInteger('theme_prayer_sub_category_id')->nullable();  
            $table->string('meeting_title')->nullable();  
            $table->date('meeting_date')->nullable();  
            $table->time('meeting_start_time')->nullable(); 
            $table->time('meeting_end_time')->nullable();  
            $table->enum('mode_of_meeting', ['Online', 'Offline'])->nullable();  
            $table->string('Meeting_place')->nullable();  
            $table->text('key_prayer_points')->nullable();  
            $table->text('prayer_requests')->nullable();  
            $table->string('meeting_link')->nullable(); 
            $table->enum('status', ['Completed', 'Cancelled', 'Upcoming'])->default('Upcoming')->nullable(); 
            $table->foreign('church_id')->references('id')->on('churches')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');  
            $table->foreign('church_prayer_points_id')->references('id')->on('church_prayer_points')->onDelete('cascade');  
            $table->foreign('theme_prayer_sub_category_id')->references('id')->on('prayer_sub_categories')->onDelete('cascade'); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('meetings');
    }
};
