<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrayerPoint extends Model
{
    use HasFactory;

    public function category()
    {
        return $this->belongsTo(PrayerCategory::class, 'prayer_category_id');
    }

    // Relationship with PrayerSubCategory
    public function subCategory()
    {
        return $this->belongsTo(PrayerSubCategory::class, 'prayer_sub_category_id');
    }
    
     public function prayerLogs()
    {
        return $this->hasMany(PrayerLog::class, 'prayer_points_id');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
