
<?php $__env->startSection('content'); ?> 

<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Leader Management
        </h1>
      </div>
    </div>
    <section class="leavereq-info">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="buttons-container">
              <div id="buttons-container"></div>
              <a class="add-emp btn" href="<?php echo e(route('admin.add_leader')); ?>"><i class="fa-regular fa-plus"></i> Add New Leader</a>
            </div>
          </div>
        </div>
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
            <div class="tile">
              <div class="tile-body">
                <div class="table-responsive">
                  <!-- table start from here -->
                  <table class="table table-hover table-bordered" id="sampleTable">
                    <thead>
                      <tr>
                      <th>S.No.</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email Id</th>
                        <th>Phone no.</th>
                        <th>User Role </th>
                        <th>User Status </th>
                        <th>Church Assign</th>
					              <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php if(count($leaders) > 0): ?>
                          <?php $__currentLoopData = $leaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><?php echo e($leader->first_name ?? ''); ?></td>
                            <td><?php echo e($leader->last_name ?? ''); ?></td>
                            <td><?php echo e($leader->email ?? ''); ?></td>
                            <td><?php echo e($leader->phone_no ?? ''); ?></td>
                            <td><?php echo e($leader->user_role ?? ''); ?></td>
                            <td><?php echo e($leader->user_status ?? ''); ?></td>
                            <td><?php echo e($leader->church->church_name ?? ''); ?></td>

                            <td class="flex-td">
                              <a href="<?php echo e(route('admin.edit_leader',$leader->id)); ?>" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                              <a href="<?php echo e(route('admin.delete_leader',$leader->id)); ?>" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                            </td>
                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                          <tr>
                              <td colspan="7" class="text-center">No Church Leader found  yet,Lets Add Church Leaders.</td>
                          </tr>
                        <?php endif; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?php echo e(session('success')); ?>",
        confirmButtonText: 'OK'
    }).then((result) => {
       
    });
</script>
<?php endif; ?>

<?php if(session('error')): ?>
  <script>
      Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: "<?php echo e(session('error')); ?>",
          confirmButtonText: 'OK'
      });
  </script>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp2\htdocs\churchappadmin\resources\views/admin/leader.blade.php ENDPATH**/ ?>