<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ChurchManagementController;
use App\Http\Controllers\UserManagementController;
use App\Http\Controllers\LeaderController;
use App\Http\Controllers\PrayerPointController;
use App\Http\Controllers\PrayerSubCategoryController;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/',[AuthController::class,'Login'])->name('login');
Route::post('storelogin',[AuthController::class,'StoreLogin'])->name('admin.storelogin');

Route::prefix('admin')->middleware(['auth:admin'])->group(function () {

    Route::get('dashboard',[DashboardController::class,'Dashboard'])->name('admin.dashboard');

    Route::get('church',[ChurchManagementController::class,'Church'])->name('admin.church');
    Route::get('add-church',[ChurchManagementController::class,'AddChurch'])->name('admin.add_church');
    Route::post('store_church',[ChurchManagementController::class,'StoreChurch'])->name('admin.store_church');
    Route::get('edit-church/{id}',[ChurchManagementController::class,'EditChurch'])->name('admin.edit_church');
    Route::post('update_church/{id}',[ChurchManagementController::class,'UpdateChurch'])->name('admin.update_church');
    Route::get('delete-church/{id}',[ChurchManagementController::class,'DeleteChurch'])->name('admin.delete_church');

    Route::get('leaders',[LeaderController::class,'Leaders'])->name('admin.leaders');
    Route::get('add-leader',[LeaderController::class,'AddLeader'])->name('admin.add_leader');
    Route::post('store-leader',[LeaderController::class,'StoreLeader'])->name('admin.store_leader');
    Route::get('edit-leader/{id}',[LeaderController::class,'EditLeader'])->name('admin.edit_leader');
    Route::post('update_leader/{id}',[LeaderController::class,'UpdateLeader'])->name('admin.update_leader');
    Route::get('delete-leader/{id}',[LeaderController::class,'DeleteLeader'])->name('admin.delete_leader');

    Route::get('users',[UserManagementController::class,'User'])->name('admin.users');
    Route::get('edit-user/{id}',[UserManagementController::class,'EditLeader'])->name('admin.edit_user');
    Route::get('delete-user/{id}',[UserManagementController::class,'DeleteUser'])->name('admin.delete_user');
    Route::post('update_user/{id}',[UserManagementController::class,'UpdateUser'])->name('admin.update_user');

    
    Route::get('prayer_points',[PrayerPointController::class,'PrayerPoints'])->name('admin.prayer_points');
    Route::get('get-prayer-sub-categories', [PrayerPointController::class,'getPrayerSubCategories'])->name('admin.get_prayer_sub_categories');
    Route::get('add_prayer_points',[PrayerPointController::class,'AddPrayerPoints'])->name('admin.add_prayer_points');
    Route::post('store-prayer-point',[PrayerPointController::class,'StorePrayerPoint'])->name('admin.store_prayer_point');
    Route::post('prayer-update-status',[PrayerPointController::class,'PrayerUpdateStatus'])->name('admin.prayer_update_status');
    Route::get('edit-prayer-point/{id}',[PrayerPointController::class,'EditPrayerPoint'])->name('admin.edit_prayer_point');
    Route::post('update_prayer_point/{id}',[PrayerPointController::class,'UpdatePrayerPoint'])->name('admin.update_prayer_point');
    Route::get('delete-prayer-point/{id}',[PrayerPointController::class,'DeletePrayerPoint'])->name('admin.delete_prayer_point');

    Route::get('prayer-sub-category',[PrayerSubCategoryController::class,'PrayerSubCategory'])->name('admin.prayer_sub_category');
    Route::get('add-prayer-sub-category',[PrayerSubCategoryController::class,'AddPrayerSubCategory'])->name('admin.add_prayer_sub_category');
    Route::post('store-prayer-sub-category',[PrayerSubCategoryController::class,'StorePrayerSubCategory'])->name('admin.store_prayer_sub_category');
    Route::get('edit-prayer-sub-category/{id}',[PrayerSubCategoryController::class,'EditPrayerSubCategory'])->name('admin.edit_prayer_sub_category');
    Route::post('update-prayer-sub-category/{id}',[PrayerSubCategoryController::class,'UpdatePrayerSubCategory'])->name('admin.update_prayer_sub_category');
    Route::get('delete-prayer-sub-category/{id}',[PrayerSubCategoryController::class,'DeletePrayerSubCategory'])->name('admin.delete_prayer_sub_category');
   
    Route::get('change-password',[AuthController::class,'Changepassword'])->name('admin.change_password');
    Route::post('store-change-password',[AuthController::class,'StoreChangepassword'])->name('admin.storechangepassword');
    Route::get('logout',[AuthController::class,'Logout'])->name('admin.logout');

    Route::get('notification',[AuthController::class,'Notification'])->name('admin.notification');
    Route::post('add-notification',[AuthController::class,'AddNotification'])->name('admin.add_notification');


});

