@extends('admin.layouts.app')
@section('content')
@php
use Illuminate\Support\Str;
@endphp

<div class="app-title">
    <div>
        <h1>
            <i class="fa-light fa-receipt mx-1"></i> Prayer Sub Category
        </h1>
    </div>
</div>

<section class="leavereq-info">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="buttons-container">
                    <div id="buttons-container"></div>
                    <a class="add-emp btn" href="{{ route('admin.add_prayer_sub_category')}}"><i class="fa-regular fa-plus"></i> Add Prayer Sub Category</a>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <!-- table start from here -->
                            <table class="table table-hover table-bordered" id="sampleTable">

                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>Prayer Sub-Category Name</th>
                                        <th>Prayer Category</th>
                                        <th>Prayer Sub-Category Description</th>
                                        
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($prayer_sub_categories) > 0 )
                                    @foreach($prayer_sub_categories as $prayer_sub_category)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $prayer_sub_category->prayer_sub_cat_name ?? ''}}</td>
                                        <td>{{ $prayer_sub_category->category->prayer_category_name ?? ''}}</td>
                                        <td>{{ Str::words($prayer_sub_category->prayer_sub_cat_description, 5, '...') }}</td>
                                      

                                        <td class="flex-td">
                                            <a href="{{ route('admin.edit_prayer_sub_category',$prayer_sub_category->id )}}" class="btn-edit" data-id="1"><i class="fa-regular fa-pen-to-square"></i></a>
                                            <a href="{{ route('admin.delete_prayer_sub_category',$prayer_sub_category->id )}}" class="btn-delete " data-id="1"><i class="fa-regular fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="6" class="text-center">No Prayer Point Added yet,Lets Add Prayer Point.</td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "{{ session('success') }}",
        confirmButtonText: 'OK'
    }).then((result) => {

    });
</script>
@endif

@if (session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: "{{ session('error') }}",
        confirmButtonText: 'OK'
    });
</script>
@endif



@endsection