@extends('admin.layouts.app')
@section('content')
<div class="app-title">
	<div>
		<h1>
			<i class="fa-regular fa-plus mx-1"></i> Edit User
		</h1>
	</div>
</div>

<section class="acc-form">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-8 col-sm-12 col-xs-12 col-md-8">
				<div class="tile">
					<div class="tile-body">
						<!-- form start from here -->
						<form class="emp-master-form" action="{{ route('admin.update_user',$user->id)}}" method="POST" enctype="multipart/form-data">
							@csrf
							<input type="hidden" name="id" value="{{ $user->id }}">

							<div class="row">
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="name">First Name:</label>
										<input type="text" class="form-control" name="first_name" id="first_name" value="{{ $user->first_name ?? ''}}" placeholder="Enter First Name">
									</div>
									@error('first_name')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="name">Last Name:</label>
										<input type="text" class="form-control" name="last_name" id="last_name" value="{{ $user->last_name ?? ''}}" placeholder="Enter Last Name">
									</div>
									@error('last_name')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="email">Email:</label>
										<input type="email" class="form-control" name="email" id="email" value="{{ $user->email ?? ''}}" placeholder="Enter Email">
									</div>
									@error('email')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
							
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="user_role">User Role:</label>
										<select id="user_role" name="user_role" class="form-control" required>
											<option value="" disabled>Select Role</option>
											<option value="Prayer Warrior" {{ isset($user) && $user->user_role == 'Prayer Warrior' ? 'selected' : '' }}>Prayer Warrior</option>
											<option value="Pastor" {{ isset($user) && $user->user_role == 'Pastor' ? 'selected' : '' }}>Pastor</option>
											<option value="Prayer (Leader)" {{ isset($user) && $user->user_role == 'Prayer (Leader)' ? 'selected' : '' }}>Prayer (Leader)</option>
											<option value="Senior Prayer Warrior (Leader)" {{ isset($user) && $user->user_role == 'Senior Prayer Warrior (Leader)' ? 'selected' : '' }}>Senior Prayer Warrior (Leader)</option>
										</select>
									</div>
									@error('user_role')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>
								<div class="col-lg-12 col-sm-12 col-md-12 col-xs-12 mt-2 mb-2">
									<div class="form-group">
										<label class="form-head mb-1" for="user_status">User Status:</label>
										<select id="user_status" name="user_status" class="form-control" required>
											<option value="" disabled>Select Status</option>
											<option value="Prayer Warrior" {{ isset($user) && $user->user_status == 'Prayer Warrior' ? 'selected' : '' }}>Prayer Warrior</option>
											<option value="Champion Warrior" {{ isset($user) && $user->user_status == 'Champion Warrior' ? 'selected' : '' }}>Champion Warrior</option>
											<option value="Elite Warrior" {{ isset($user) && $user->user_status == 'Elite Warrior' ? 'selected' : '' }}>Elite Warrior</option>
											<option value="Inactive User" {{ isset($user) && $user->user_status == 'Inactive User' ? 'selected' : '' }}>Inactive User</option>
										</select>
									</div>
									@error('user_status')
									<div class="text-danger mt-1">{{ $message }}</div>
									@enderror
								</div>

								<div class="col-md-12 col-lg-12 col-sm-12 col-xs-12 mt-4 mb-2">
									<div class="form-group text-center">
										<button class="btn submit-btn w-100" type="submit">
											<i class="fa-sharp fa-light fa-paper-plane mx-2"></i> Update User </button>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@if (session('success'))
<script>
	Swal.fire({
		icon: 'success',
		title: 'Success!',
		text: "{{ session('success') }}",
		confirmButtonText: 'OK'
	}).then((result) => {
		if (result.isConfirmed) {
			window.location.href = "{{ route('admin.users') }}";
		}
	});
</script>
@endif


@endsection