@extends('admin.layouts.app')
@section('content')
<div class="app-title">
      <div>
        <h1>
        <i class="fa-light fa-receipt mx-1"></i> Change Password
        </h1>
      </div>
    </div>
    <!-- change password -->
    <div class="bg-transparent d-flex justify-content-center align-items-center ">
        <div class="card shadow" style="width: 24rem;">
            <div class="card-body">
           
                <h5 class="card-title text-center mb-3 mt-3">Change Password</h5>
                <form action="{{ route('admin.storechangepassword')}}" method="POST" enctype="multipart/form-data" >
                    @csrf
                    <div class="mb-3">
                        <label for="current-password" class="form-label">Current Password</label>
                        <input type="password" class="form-control" id="current-password" name="current_password" value="{{ old('current_password') }}" placeholder="Enter current password">
                        @error('current_password')
                                <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="new-password" class="form-label">New Password</label>
                        <input type="password" class="form-control" id="new-password" name="newpassword" value="{{ old('newpassword') }}" placeholder="Enter new password">
                        @error('newpassword')
                                <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="confirm-password" class="form-label">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm-password" name="newpassword_confirmation" value="{{ old('newpassword_confirmation')}}" placeholder="Confirm new password">
                        @error('newpassword_confirmation')
                                <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <button type="submit" class="btn w-100">Change Password</button>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    @if (session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: "{{ session('success') }}",
            confirmButtonText: 'OK'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "{{ route('admin.logout') }}";
            }
        });
    </script>
    @endif
@endsection